<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Appointments extends Eloquent {

	protected $table = 'appointments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('appointment_date', 'title');

	public function manger()
	{
		return $this->belongsTo('App\Modules\HR\Entities\Employee', 'employee_id');
	}

}