<?php

namespace App\Modules\HR\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attachment extends Eloquent {

	protected $table = 'attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('file', 'type', 'employee_id');

	public function employees()
	{
		return $this->belongsTo('App\Modules\HR\Entities\Employee');
	}

}