<?php

namespace App\Modules\CustomerService\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CustomerService extends Eloquent {

	protected $table = 'customer_services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('employee_id', 'status', 'calls_count', 'sms_messages_count', 'whatsapp_messages_count', 'call_duration', 'call_duration_average', 'rate');

	public function employee()
	{
		return $this->belongsTo('App\Modules\HR\Entities\Employee');
	}

	public function messages()
	{
		return $this->hasMany('App\Modules\CustomerService\Entities\Message');
	}

	public function calls()
	{
		return $this->hasMany('App\Modules\CustomerService\Entities\Call');
	}

}