<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MeetingDecision extends Eloquent {

	protected $table = 'meeting_decisions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('content', 'meeting_id');

	public function meetings()
	{
		return $this->belongsTo('App\Modules\Secretariat\Entities\Meeting');
	}

}