<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('employee_id', 'employee_number', 'password', 'is_send_otp');
	protected $hidden = array('password');

	public function employee()
	{
		return $this->belongsTo('App\Modules\HR\Entities\Employee');
	}

}