<?php

namespace App\Modules\Reception\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Visit extends Eloquent {

	protected $table = 'visits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'management_id', 'type', 'status');

	public function management()
	{
		return $this->belongsTo('App\Modules\HR\Entities\Management');
	}

	public function visitors()
	{
		return $this->hasMany('App\Modules\Reception\Entities\Visitor');
	}

	public function employees()
	{
		return $this->belongsToMany('App\Modules\HR\Entities\Employee');
	}

}