<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->string('employee_number')->unique();
			$table->string('password');
			$table->tinyInteger('is_send_otp')->default('0');
			$table->string('otp', 8)->nullable();
			$table->string('blocked_key')->nullable();
			$table->timestamp('deactivated_from')->nullable();
			$table->timestamp('deactivated_at')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}