<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('managements', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('managements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('management_id')->references('id')->on('managements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationalities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('employee_job_information_id')->references('id')->on('employee_job_informations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee_job_informations', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('allowance_employee', function(Blueprint $table) {
			$table->foreign('allowance_id')->references('id')->on('allowances')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('allowance_employee', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employee_job_informations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('calls', function(Blueprint $table) {
			$table->foreign('customer_service_id')->references('id')->on('customer_services')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('call_access_employees', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('call_access_employees', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('customer_service_id')->references('id')->on('customer_services')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meetings', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meetings', function(Blueprint $table) {
			$table->foreign('meeting_room_id')->references('id')->on('meeting_rooms')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee_meeting', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee_meeting', function(Blueprint $table) {
			$table->foreign('meeting_id')->references('id')->on('meetings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meeting_discussion_points', function(Blueprint $table) {
			$table->foreign('meeting_id')->references('id')->on('meetings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meeting_decisions', function(Blueprint $table) {
			$table->foreign('meeting_id')->references('id')->on('meetings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('management_id')->references('id')->on('managements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('visitors', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('visits')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee_visit', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee_visit', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('visits')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reception_reports', function(Blueprint $table) {
			$table->foreign('management_id')->references('id')->on('managements')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('managements', function(Blueprint $table) {
			$table->dropForeign('managements_parent_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_management_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_nationality_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_employee_job_information_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_employee_id_foreign');
		});
		Schema::table('employee_job_informations', function(Blueprint $table) {
			$table->dropForeign('employee_job_informations_job_id_foreign');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->dropForeign('custodies_employee_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_employee_id_foreign');
		});
		Schema::table('allowance_employee', function(Blueprint $table) {
			$table->dropForeign('allowance_employee_allowance_id_foreign');
		});
		Schema::table('allowance_employee', function(Blueprint $table) {
			$table->dropForeign('allowance_employee_employee_id_foreign');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->dropForeign('customer_services_employee_id_foreign');
		});
		Schema::table('calls', function(Blueprint $table) {
			$table->dropForeign('calls_customer_service_id_foreign');
		});
		Schema::table('call_access_employees', function(Blueprint $table) {
			$table->dropForeign('call_access_employees_call_id_foreign');
		});
		Schema::table('call_access_employees', function(Blueprint $table) {
			$table->dropForeign('call_access_employees_employee_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_customer_service_id_foreign');
		});
		Schema::table('meetings', function(Blueprint $table) {
			$table->dropForeign('meetings_employee_id_foreign');
		});
		Schema::table('meetings', function(Blueprint $table) {
			$table->dropForeign('meetings_meeting_room_id_foreign');
		});
		Schema::table('employee_meeting', function(Blueprint $table) {
			$table->dropForeign('employee_meeting_employee_id_foreign');
		});
		Schema::table('employee_meeting', function(Blueprint $table) {
			$table->dropForeign('employee_meeting_meeting_id_foreign');
		});
		Schema::table('meeting_discussion_points', function(Blueprint $table) {
			$table->dropForeign('meeting_discussion_points_meeting_id_foreign');
		});
		Schema::table('meeting_decisions', function(Blueprint $table) {
			$table->dropForeign('meeting_decisions_meeting_id_foreign');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_management_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_employee_id_foreign');
		});
		Schema::table('visitors', function(Blueprint $table) {
			$table->dropForeign('visitors_visit_id_foreign');
		});
		Schema::table('employee_visit', function(Blueprint $table) {
			$table->dropForeign('employee_visit_employee_id_foreign');
		});
		Schema::table('employee_visit', function(Blueprint $table) {
			$table->dropForeign('employee_visit_visit_id_foreign');
		});
		Schema::table('reception_reports', function(Blueprint $table) {
			$table->dropForeign('reception_reports_management_id_foreign');
		});
	}
}