<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('drawing', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organisation')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('drawing', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctype')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('spec', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organisation')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('spec', function(Blueprint $table) {
			$table->foreign('doctype_id')->references('id')->on('doctype')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('drawing', function(Blueprint $table) {
			$table->dropForeign('drawing_org_id_foreign');
		});
		Schema::table('drawing', function(Blueprint $table) {
			$table->dropForeign('drawing_doctype_id_foreign');
		});
		Schema::table('spec', function(Blueprint $table) {
			$table->dropForeign('spec_org_id_foreign');
		});
		Schema::table('spec', function(Blueprint $table) {
			$table->dropForeign('spec_doctype_id_foreign');
		});
	}
}