<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function role()
	{
		return $this->hasOne('App\Models\User\Role', 'role_id');
	}

	public function vehicles()
	{
		return $this->hasMany('App\Models\User\Vehicle');
	}

	public function contributors()
	{
		return $this->hasMany('App\Models\User\Request\Request');
	}

}