<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PriceBand extends Model 
{

    protected $table = 'price_band';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function priceLists()
    {
        return $this->belongsToMany('PriceList', 'product_band_pivot', 'band_id', 'product_id');
    }

    public function items()
    {
        return $this->hasMany('PriceBandItem', 'band_id');
    }

}