<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PriceBandItem extends Model 
{

    protected $table = 'price_band_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('width_id', 'drop_id', 'price');

    public function width()
    {
        return $this->hasOne('PriceBandWidth');
    }

    public function drop()
    {
        return $this->hasOne('PriceBandDrop');
    }

}