<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function brand()
    {
        return $this->hasOne('ProductBrand', 'brand_id');
    }

    public function categories()
    {
        return $this->belongsToMany('ProductCategory', 'product_categories', 'product_id', 'category_id');
    }

    public function materials()
    {
        return $this->belongsToMany('ProductMaterial', 'product_material_pivot', 'product_id', 'material_id');
    }

}