<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PriceList extends Model 
{

    protected $table = 'price_list';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function bands()
    {
        return $this->belongsToMany('Product', 'price_list_product_pivot', 'list_id', 'band_id');
    }

    public function items()
    {
        return $this->hasMany('\PriceBandItem');
    }

}