<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PriceList extends Eloquent {

	protected $table = 'price_list';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function bands()
	{
		return $this->belongsToMany('Product', 'price_list_product_pivot', 'list_id', 'band_id');
	}

	public function items()
	{
		return $this->hasMany('\PriceBandItem');
	}

}