<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PriceBand extends Eloquent {

	protected $table = 'price_band';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function priceLists()
	{
		return $this->belongsToMany('PriceList', 'product_band_pivot', 'band_id', 'product_id');
	}

	public function items()
	{
		return $this->hasMany('PriceBandItem', 'band_id');
	}

}