<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PriceBandItem extends Eloquent {

	protected $table = 'price_band_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('width_id', 'drop_id', 'price');

	public function width()
	{
		return $this->hasOne('PriceBandWidth');
	}

	public function drop()
	{
		return $this->hasOne('PriceBandDrop');
	}

}