<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('form', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('application')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('form_question', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('form')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('question_option', function(Blueprint $table) {
			$table->foreign('form_question_id')->references('id')->on('form_question')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('form_question')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('form', function(Blueprint $table) {
			$table->dropForeign('form_application_id_foreign');
		});
		Schema::table('form_question', function(Blueprint $table) {
			$table->dropForeign('form_question_form_id_foreign');
		});
		Schema::table('question_option', function(Blueprint $table) {
			$table->dropForeign('question_option_form_question_id_foreign');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->dropForeign('answer_question_id_foreign');
		});
	}
}