<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->string('phone');
			$table->timestamp('last_donation')->nullable();
			$table->string('blood_type');
			$table->date('date_of_birth')->nullable();
			$table->string('token');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}