<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblGroubJoinRequestsTable extends Migration {

	public function up()
	{
		Schema::create('tbl_groub_join_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('groub_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->enum('status', array('pending', 'accepted', 'rejected'))->nullable();
			$table->timestamps();
			$table->datetime('time');
		});
	}

	public function down()
	{
		Schema::drop('tbl_groub_join_requests');
	}
}