<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tbl_cars', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_cars', function(Blueprint $table) {
			$table->foreign('car_brand_id')->references('id')->on('tbl_car_brand')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_cars', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('tbl_city')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_car_images', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('tbl_cars')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_groubs', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('tbl_groub_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_groubs', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_groub_member', function(Blueprint $table) {
			$table->foreign('groub_id')->references('id')->on('tbl_groubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_groub_member', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_groub_join_requests', function(Blueprint $table) {
			$table->foreign('groub_id')->references('id')->on('tbl_groubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_groub_join_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trips', function(Blueprint $table) {
			$table->foreign('orginized_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('tbl_trips')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->foreign('trip_day_id')->references('id')->on('tbl_trip_days')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->foreign('groub_id')->references('id')->on('tbl_groubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('tbl_trips')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->foreign('guest_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_days', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('tbl_trips')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_point', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('tbl_trips')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_member', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('tbl_trips')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tbl_trip_member', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('tbl_cars', function(Blueprint $table) {
			$table->dropForeign('tbl_cars_user_id_foreign');
		});
		Schema::table('tbl_cars', function(Blueprint $table) {
			$table->dropForeign('tbl_cars_car_brand_id_foreign');
		});
		Schema::table('tbl_cars', function(Blueprint $table) {
			$table->dropForeign('tbl_cars_city_id_foreign');
		});
		Schema::table('tbl_car_images', function(Blueprint $table) {
			$table->dropForeign('tbl_car_images_car_id_foreign');
		});
		Schema::table('tbl_groubs', function(Blueprint $table) {
			$table->dropForeign('tbl_groubs_type_id_foreign');
		});
		Schema::table('tbl_groubs', function(Blueprint $table) {
			$table->dropForeign('tbl_groubs_created_by_foreign');
		});
		Schema::table('tbl_groub_member', function(Blueprint $table) {
			$table->dropForeign('tbl_groub_member_groub_id_foreign');
		});
		Schema::table('tbl_groub_member', function(Blueprint $table) {
			$table->dropForeign('tbl_groub_member_user_id_foreign');
		});
		Schema::table('tbl_groub_join_requests', function(Blueprint $table) {
			$table->dropForeign('tbl_groub_join_requests_groub_id_foreign');
		});
		Schema::table('tbl_groub_join_requests', function(Blueprint $table) {
			$table->dropForeign('tbl_groub_join_requests_user_id_foreign');
		});
		Schema::table('tbl_trips', function(Blueprint $table) {
			$table->dropForeign('tbl_trips_orginized_id_foreign');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_join_request_trip_id_foreign');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_join_request_user_id_foreign');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_join_request_trip_day_id_foreign');
		});
		Schema::table('tbl_trip_join_request', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_join_request_groub_id_foreign');
		});
		Schema::table('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->dropForeign('tbl_kiloshare_trans_trip_id_foreign');
		});
		Schema::table('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->dropForeign('tbl_kiloshare_trans_guest_id_foreign');
		});
		Schema::table('tbl_kiloshare_trans', function(Blueprint $table) {
			$table->dropForeign('tbl_kiloshare_trans_owner_id_foreign');
		});
		Schema::table('tbl_trip_days', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_days_trip_id_foreign');
		});
		Schema::table('tbl_trip_point', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_point_trip_id_foreign');
		});
		Schema::table('tbl_trip_member', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_member_trip_id_foreign');
		});
		Schema::table('tbl_trip_member', function(Blueprint $table) {
			$table->dropForeign('tbl_trip_member_user_id_foreign');
		});
	}
}