<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('pre_name', array('a', 'b', 'c'));
			$table->string('first_name');
			$table->string('last_name');
			$table->date('birth_date');
			$table->string('id_card', 13);
			$table->string('building');
			$table->string('room');
			$table->string('floor');
			$table->string('village');
			$table->string('house_no');
			$table->string('village_no');
			$table->string('lane');
			$table->string('road');
			$table->string('sub_district');
			$table->string('district');
			$table->string('province');
			$table->string('postal_code');
			$table->enum('status', array('a', 'b', 'c'));
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}