<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DoctorBranch extends Model 
{

    protected $table = 'doctor_branches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function doctor()
    {
        return $this->belongsTo('\Doctor', 'doctor_id');
    }

    public function branch()
    {
        return $this->belongsTo('\Branch', 'branch_id');
    }

}