<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RoomService extends Model 
{

    protected $table = 'room_services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function room()
    {
        return $this->belongsTo('Room', 'room_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctor', 'doctor_id');
    }

}