<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function serivceCategory()
    {
        return $this->belongsTo('ServiceCategory', 'service_catogry_id');
    }

    public function tag()
    {
        return $this->hasMany('TagService');
    }

    public function reservation()
    {
        return $this->hasMany('ReservationService');
    }

}