<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('Name', 255)->default('name');
			$table->datetime('working_from');
			$table->datetime('working_to');
			$table->string('lat', 255);
			$table->string('long', 255);
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}