<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_branches', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_branches', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_category_id')->references('id')->on('service_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_products_stock', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_products_stock', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_products_stock', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_product_amount', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_products', function(Blueprint $table) {
			$table->foreign('purchase_id')->references('id')->on('purchases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tag_services', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tag')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tag_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_information', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_schedules', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_schedules', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_schedules', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_time_slots', function(Blueprint $table) {
			$table->foreign('doctor_working_hour_id')->references('id')->on('doctor_schedules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('promo_code_id')->references('id')->on('promo_codes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservation_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservation_services', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medications', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medication_dates', function(Blueprint $table) {
			$table->foreign('medication_id')->references('id')->on('medications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservation_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reservation_products', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('treatment_plans', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('treatment_plans', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('treatment_plans', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('treatment_plan_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('treatment_plan_services', function(Blueprint $table) {
			$table->foreign('treatment_plan_id')->references('id')->on('treatment_plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_branch_id_foreign');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->dropForeign('room_services_service_id_foreign');
		});
		Schema::table('room_services', function(Blueprint $table) {
			$table->dropForeign('room_services_room_id_foreign');
		});
		Schema::table('doctor_branches', function(Blueprint $table) {
			$table->dropForeign('doctor_branches_doctor_id_foreign');
		});
		Schema::table('doctor_branches', function(Blueprint $table) {
			$table->dropForeign('doctor_branches_branch_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_category_id_foreign');
		});
		Schema::table('branch_products_stock', function(Blueprint $table) {
			$table->dropForeign('branch_products_stock_product_id_foreign');
		});
		Schema::table('branch_products_stock', function(Blueprint $table) {
			$table->dropForeign('branch_products_stock_branch_id_foreign');
		});
		Schema::table('branch_products_stock', function(Blueprint $table) {
			$table->dropForeign('branch_products_stock_unit_id_foreign');
		});
		Schema::table('unit_product_amount', function(Blueprint $table) {
			$table->dropForeign('unit_product_amount_unit_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_supplier_id_foreign');
		});
		Schema::table('purchase_products', function(Blueprint $table) {
			$table->dropForeign('purchase_products_purchase_id_foreign');
		});
		Schema::table('tag_services', function(Blueprint $table) {
			$table->dropForeign('tag_services_tag_id_foreign');
		});
		Schema::table('tag_services', function(Blueprint $table) {
			$table->dropForeign('tag_services_service_id_foreign');
		});
		Schema::table('user_information', function(Blueprint $table) {
			$table->dropForeign('user_information_user_id_foreign');
		});
		Schema::table('doctor_schedules', function(Blueprint $table) {
			$table->dropForeign('doctor_schedules_created_by_foreign');
		});
		Schema::table('doctor_schedules', function(Blueprint $table) {
			$table->dropForeign('doctor_schedules_doctor_id_foreign');
		});
		Schema::table('doctor_schedules', function(Blueprint $table) {
			$table->dropForeign('doctor_schedules_branch_id_foreign');
		});
		Schema::table('doctor_time_slots', function(Blueprint $table) {
			$table->dropForeign('doctor_time_slots_doctor_working_hour_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_branch_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_room_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_doctor_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_patient_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_promo_code_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_reservation_id_foreign');
		});
		Schema::table('reservation_services', function(Blueprint $table) {
			$table->dropForeign('reservation_services_service_id_foreign');
		});
		Schema::table('reservation_services', function(Blueprint $table) {
			$table->dropForeign('reservation_services_reservation_id_foreign');
		});
		Schema::table('medications', function(Blueprint $table) {
			$table->dropForeign('medications_reservation_id_foreign');
		});
		Schema::table('medications', function(Blueprint $table) {
			$table->dropForeign('medications_user_id_foreign');
		});
		Schema::table('medication_dates', function(Blueprint $table) {
			$table->dropForeign('medication_dates_medication_id_foreign');
		});
		Schema::table('reservation_products', function(Blueprint $table) {
			$table->dropForeign('reservation_products_product_id_foreign');
		});
		Schema::table('reservation_products', function(Blueprint $table) {
			$table->dropForeign('reservation_products_reservation_id_foreign');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->dropForeign('invoice_items_invoice_id_foreign');
		});
		Schema::table('treatment_plans', function(Blueprint $table) {
			$table->dropForeign('treatment_plans_user_id_foreign');
		});
		Schema::table('treatment_plans', function(Blueprint $table) {
			$table->dropForeign('treatment_plans_doctor_id_foreign');
		});
		Schema::table('treatment_plans', function(Blueprint $table) {
			$table->dropForeign('treatment_plans_reservation_id_foreign');
		});
		Schema::table('treatment_plan_services', function(Blueprint $table) {
			$table->dropForeign('treatment_plan_services_service_id_foreign');
		});
		Schema::table('treatment_plan_services', function(Blueprint $table) {
			$table->dropForeign('treatment_plan_services_treatment_plan_id_foreign');
		});
	}
}