<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Branch extends Eloquent {

	protected $table = 'branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function room()
	{
		return $this->hasMany('\Room');
	}

	public function doctor()
	{
		return $this->hasMany('DoctorBranch');
	}

	public function product()
	{
		return $this->hasMany('BranchProductStock');
	}

}