<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('phone', 255)->unique();
			$table->string('image', 255);
			$table->boolean('active')->nullable()->default(0);
			$table->string('latt', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->enum('type', array('admin', 'jr_admin', 'doctor', 'patient', 'consult_doctor'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}