<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DoctorBranch extends Eloquent {

	protected $table = 'doctor_branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function doctor()
	{
		return $this->belongsTo('\Doctor', 'doctor_id');
	}

	public function branch()
	{
		return $this->belongsTo('\Branch', 'branch_id');
	}

}