<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function reservation()
	{
		return $this->belongsTo('Reservation', 'reservation_id');
	}

	public function invoiceItem()
	{
		return $this->hasMany('InvoiceItem');
	}

}