<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Room extends Eloquent {

	protected $table = 'rooms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function branch()
	{
		return $this->belongsTo('\Branch', 'branch_id');
	}

	public function doctor()
	{
		return $this->hasMany('RoomService');
	}

}