<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RoomService extends Eloquent {

	protected $table = 'room_services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function room()
	{
		return $this->belongsTo('Room', 'room_id');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctor', 'doctor_id');
	}

}