<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function serivceCategory()
	{
		return $this->belongsTo('ServiceCategory', 'service_catogry_id');
	}

	public function tag()
	{
		return $this->hasMany('TagService');
	}

	public function reservation()
	{
		return $this->hasMany('ReservationService');
	}

}