<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function information()
	{
		return $this->hasMany('UserInformation');
	}

	public function medication()
	{
		return $this->hasMany('Medication');
	}

	public function treatmentPlan()
	{
		return $this->hasMany('TreatmentPlan');
	}

}