<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorTable extends Migration {

	public function up()
	{
		Schema::create('vendor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->string('number');
			$table->enum('is_active', array(''));
			$table->string('state');
			$table->string('district');
			$table->string('place');
			$table->string('pincode');
			$table->string('whatsapp');
			$table->string('gst');
			$table->string('pancard');
		});
	}

	public function down()
	{
		Schema::drop('vendor');
	}
}