<?php

namespace App;

class ServiceProvider extends Eloquent {

	protected $table = 'service_providers';
	public $timestamps = true;

	public function employees()
	{
		return $this->hasMany('Employee', 'service_provider_id');
	}

	public function openingHours()
	{
		return $this->hasMany('OpeningHours', 'service_provider_id');
	}

	public function priceLists()
	{
		return $this->hasMany('PriceList', 'service_provider_id');
	}

	public function notification()
	{
		return $this->hasOne('Notification', 'service_provider_id');
	}

	public function ServiceProviderPushNotification()
	{
		return $this->hasMany('PushNotification', 'service_provider_id');
	}

	public function ServiceProviderMessage()
	{
		return $this->hasMany('Message', 'service_provider_id');
	}

}