<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('id_position')->references('id')->on('position')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('id_schedule')->references('id')->on('schedule')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('id_modality')->references('id')->on('modality')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('id_currency')->references('id')->on('currency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_has_rol', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_has_rol', function(Blueprint $table) {
			$table->foreign('id_rol')->references('id')->on('rol')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('id_users')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rol_has_actions', function(Blueprint $table) {
			$table->foreign('id_rol')->references('id')->on('rol')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rol_has_actions', function(Blueprint $table) {
			$table->foreign('id_actions')->references('id')->on('actions_rols')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modality', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('currency', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deductions', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bonus', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('position', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('department', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payroll', function(Blueprint $table) {
			$table->foreign('id_modality')->references('id')->on('modality')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payroll', function(Blueprint $table) {
			$table->foreign('id_companies')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('details_employees', function(Blueprint $table) {
			$table->foreign('id_employee')->references('id')->on('employee')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payroll_has_details_employees', function(Blueprint $table) {
			$table->foreign('id_payroll')->references('id')->on('payroll')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payroll_has_details_employees', function(Blueprint $table) {
			$table->foreign('id_details_employees')->references('id')->on('details_employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payroll_has_details_totals', function(Blueprint $table) {
			$table->foreign('id_payroll')->references('id')->on('payroll')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payroll_has_details_totals', function(Blueprint $table) {
			$table->foreign('id_details_totals')->references('id')->on('details_totals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees_bonus', function(Blueprint $table) {
			$table->foreign('id_details_employees')->references('id')->on('details_employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees_bonus', function(Blueprint $table) {
			$table->foreign('id_details_bonus')->references('id')->on('details_bonus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_deductions', function(Blueprint $table) {
			$table->foreign('id_details_employee')->references('id')->on('details_employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_deductions', function(Blueprint $table) {
			$table->foreign('id_details_deductions')->references('id')->on('details_deductions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_id_position_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_id_companies_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_id_schedule_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_id_modality_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_id_currency_foreign');
		});
		Schema::table('users_has_rol', function(Blueprint $table) {
			$table->dropForeign('users_has_rol_id_user_foreign');
		});
		Schema::table('users_has_rol', function(Blueprint $table) {
			$table->dropForeign('users_has_rol_id_rol_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_id_users_foreign');
		});
		Schema::table('rol_has_actions', function(Blueprint $table) {
			$table->dropForeign('rol_has_actions_id_rol_foreign');
		});
		Schema::table('rol_has_actions', function(Blueprint $table) {
			$table->dropForeign('rol_has_actions_id_actions_foreign');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->dropForeign('schedule_id_companies_foreign');
		});
		Schema::table('modality', function(Blueprint $table) {
			$table->dropForeign('modality_id_companies_foreign');
		});
		Schema::table('currency', function(Blueprint $table) {
			$table->dropForeign('currency_id_companies_foreign');
		});
		Schema::table('deductions', function(Blueprint $table) {
			$table->dropForeign('deductions_id_companies_foreign');
		});
		Schema::table('bonus', function(Blueprint $table) {
			$table->dropForeign('bonus_id_companies_foreign');
		});
		Schema::table('position', function(Blueprint $table) {
			$table->dropForeign('position_id_companies_foreign');
		});
		Schema::table('department', function(Blueprint $table) {
			$table->dropForeign('department_id_companies_foreign');
		});
		Schema::table('payroll', function(Blueprint $table) {
			$table->dropForeign('payroll_id_modality_foreign');
		});
		Schema::table('payroll', function(Blueprint $table) {
			$table->dropForeign('payroll_id_companies_foreign');
		});
		Schema::table('details_employees', function(Blueprint $table) {
			$table->dropForeign('details_employees_id_employee_foreign');
		});
		Schema::table('payroll_has_details_employees', function(Blueprint $table) {
			$table->dropForeign('payroll_has_details_employees_id_payroll_foreign');
		});
		Schema::table('payroll_has_details_employees', function(Blueprint $table) {
			$table->dropForeign('payroll_has_details_employees_id_details_employees_foreign');
		});
		Schema::table('payroll_has_details_totals', function(Blueprint $table) {
			$table->dropForeign('payroll_has_details_totals_id_payroll_foreign');
		});
		Schema::table('payroll_has_details_totals', function(Blueprint $table) {
			$table->dropForeign('payroll_has_details_totals_id_details_totals_foreign');
		});
		Schema::table('employees_bonus', function(Blueprint $table) {
			$table->dropForeign('employees_bonus_id_details_employees_foreign');
		});
		Schema::table('employees_bonus', function(Blueprint $table) {
			$table->dropForeign('employees_bonus_id_details_bonus_foreign');
		});
		Schema::table('employee_deductions', function(Blueprint $table) {
			$table->dropForeign('employee_deductions_id_details_employee_foreign');
		});
		Schema::table('employee_deductions', function(Blueprint $table) {
			$table->dropForeign('employee_deductions_id_details_deductions_foreign');
		});
	}
}