<?php

namespace App\Models;

class Payroll extends Eloquent {

	protected $table = 'payroll';
	public $timestamps = true;

	public function companies()
	{
		return $this->belongsTo('App\Models\Companies', 'id_companies');
	}

	public function modality()
	{
		return $this->belongsTo('App\Models\Modality', 'id_modality');
	}

	public function payroll_has_detail()
	{
		return $this->hasMany('App\Models\Payroll_has_details_employees', 'id_payroll');
	}

	public function payroll_has_detail_totals()
	{
		return $this->hasMany('App\Models\Payroll_has_details_totals', 'id_payroll');
	}

}