<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('employee', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('id_number');
			$table->date('hire_date');
			$table->integer('id_position')->unsigned();
			$table->integer('id_companies')->unsigned();
			$table->integer('id_schedule')->unsigned();
			$table->integer('id_modality')->unsigned();
			$table->integer('id_currency')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employee');
	}
}