<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('chart_of_accounts', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('type_chart')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cost_profite_centers', function(Blueprint $table) {
			$table->foreign('type_cost_profite_id')->references('id')->on('type_cost_profites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('setup_modules', function(Blueprint $table) {
			$table->foreign('chart_of_account_id')->references('id')->on('chart_of_accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('chart_of_accounts', function(Blueprint $table) {
			$table->dropForeign('chart_of_accounts_type_id_foreign');
		});
		Schema::table('cost_profite_centers', function(Blueprint $table) {
			$table->dropForeign('cost_profite_centers_type_cost_profite_id_foreign');
		});
		Schema::table('setup_modules', function(Blueprint $table) {
			$table->dropForeign('setup_modules_chart_of_account_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_state_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_country_id_foreign');
		});
	}
}