<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cagette_denrees', function(Blueprint $table) {
			$table->foreign('id_cagette')->references('id')->on('cagette')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cagette_denrees', function(Blueprint $table) {
			$table->foreign('id_denree')->references('id')->on('denrees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('denrees', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('caddy', function(Blueprint $table) {
			$table->foreign('id_cagette')->references('id')->on('cagette')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('caddy', function(Blueprint $table) {
			$table->foreign('id_users')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paiements', function(Blueprint $table) {
			$table->foreign('id_caddy')->references('id')->on('caddy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('cagette_denrees', function(Blueprint $table) {
			$table->dropForeign('cagette_denrees_id_cagette_foreign');
		});
		Schema::table('cagette_denrees', function(Blueprint $table) {
			$table->dropForeign('cagette_denrees_id_denree_foreign');
		});
		Schema::table('denrees', function(Blueprint $table) {
			$table->dropForeign('denrees_id_user_foreign');
		});
		Schema::table('caddy', function(Blueprint $table) {
			$table->dropForeign('caddy_id_cagette_foreign');
		});
		Schema::table('caddy', function(Blueprint $table) {
			$table->dropForeign('caddy_id_users_foreign');
		});
		Schema::table('paiements', function(Blueprint $table) {
			$table->dropForeign('paiements_id_caddy_foreign');
		});
	}
}