<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('firstname');
			$table->string('email')->unique();
			$table->timestamp('email_verifed_at')->nullable();
			$table->string('password');
			$table->integer('Type');
			$table->string('rememberToken');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}