<?php

namespace Product;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'Product';
    public $timestamps = true;

    public function packages()
    {
        return $this->belongsToMany('Package')->withPivot('price', 'is_visible');
    }

    public function packageFeatures()
    {
        return $this->hasManyThrough('Package_Product', 'PackageFeature', 'Package_Product');
    }

}