<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('employee', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->date('birth_date');
			$table->date('hiring_date');
			$table->date('resignition_date');
			$table->integer('department_id')->unsigned();
			$table->integer('position_id')->unsigned();
			$table->integer('proficiency_level_id')->unsigned();
			$table->integer('employment_status_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('employee');
	}
}