<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAcademicStudiesTable extends Migration {

	public function up()
	{
		Schema::create('academic_studies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('academic_area', 150);
			$table->tinyInteger('grade');
			$table->string('academic_institution', 255);
			$table->timestamp('start_date');
			$table->timestamp('end_date');
			$table->integer('idPersona')->unsigned();
			$table->integer('idPerson')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('academic_studies');
	}
}