<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 150);
			$table->tinyInteger('type');
			$table->string('academic_institution', 255);
			$table->timestamp('start_date');
			$table->timestamp('end_date')->nullable();
			$table->integer('idPerson')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}