<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCreditBagsTable extends Migration {

	public function up()
	{
		Schema::create('credit_bags', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('publications')->default('0');
			$table->integer('highlighters')->default('0');
			$table->integer('surveys')->default('0');
			$table->integer('videos')->default('0');
			$table->integer('candidates')->default('0');
			$table->integer('psychometrics')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('credit_bags');
	}
}