<?php

class Vacancy extends Eloquent {

	protected $table = 'vacancies';
	public $timestamps = true;

	public function creator()
	{
		return $this->belongsTo('Person', 'idCreator');
	}

	public function recruiter()
	{
		return $this->belongsTo('Person', 'idRecruiter');
	}

	public function company()
	{
		return $this->belongsTo('Company', 'idCompany');
	}

	public function published()
	{
		return $this->hasMany('Vacancy_published', 'idVacancy');
	}

}