<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfessionalExperienceTable extends Migration {

	public function up()
	{
		Schema::create('professional_experience', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('company_name', 150);
			$table->string('position', 150);
			$table->integer('salary_min')->nullable();
			$table->integer('salary_max')->nullable();
			$table->timestamp('start_date')->nullable();
			$table->timestamp('end_date')->nullable();
			$table->text('work_description');
			$table->integer('idPerson')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('professional_experience');
	}
}